/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.dialog.comp;

import DE.siemens.ad.logo.app.comp.BorderJPanel;
import DE.siemens.ad.logo.app.comp.SplittedDlg;
import DE.siemens.ad.logo.dialog.CommunicationSettingPanel;
import DE.siemens.ad.logo.dialog.comp.IPAddressJTextField;
import DE.siemens.ad.logo.dialog.comp.SubnetMaskJTextField;
import DE.siemens.ad.logo.util.Language;
import DE.siemens.ad.logo.util.LogoError;
import DE.siemens.ad.logo.util.LogoProperties;
import DE.siemens.ad.logo.util.Util;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class NetworkReusablePanels {

    public static class InputIPAddressPanel
    extends BorderJPanel {
        private static final long serialVersionUID = 1L;
        private IPAddressJTextField fIPAddressJTextField;
        private IPAddressJTextField fSubnetMaskJTextField;
        private IPAddressJTextField fGatewayJTextField;
        private JButton fSelectConfigButton;

        public InputIPAddressPanel(boolean selectButtonVisible) {
            this.initComponents(selectButtonVisible);
        }

        private void initComponents(boolean selectButtonVisible) {
            this.setLayout(new GridBagLayout());
            GridBagConstraints constraints = new GridBagConstraints();
            constraints.fill = 0;
            constraints.anchor = 17;
            constraints.insets = new Insets(0, 6, 4, 0);
            constraints.gridx = 0;
            constraints.gridy = 0;
            this.add((Component)new JLabel(Language.getString("ethernet.tcpSettingPanel.columnIPAddress", "IP Address") + ":"), constraints);
            constraints.gridx = 1;
            constraints.gridy = 0;
            this.fIPAddressJTextField = new IPAddressJTextField();
            this.add((Component)this.fIPAddressJTextField, constraints);
            constraints.gridx = 0;
            constraints.gridy = 1;
            this.add((Component)new JLabel(Language.getString("ethernet.ethernetConfigurePanel.subnetMask", "Subnet Mask:")), constraints);
            constraints.gridx = 1;
            constraints.gridy = 1;
            this.fSubnetMaskJTextField = new SubnetMaskJTextField();
            this.fSubnetMaskJTextField.setMaxFirstSegmentValue(255);
            this.add((Component)this.fSubnetMaskJTextField, constraints);
            constraints.gridx = 0;
            constraints.gridy = 2;
            this.add((Component)new JLabel(Language.getString("ethernet.ethernetConfigurePanel.gatewayMask", "Gateway:")), constraints);
            constraints.gridx = 1;
            constraints.gridy = 2;
            this.fGatewayJTextField = new IPAddressJTextField();
            this.add((Component)this.fGatewayJTextField, constraints);
            this.fSelectConfigButton = new JButton(Language.getString("tool.ipConfigurePanel.Select", "Select"));
            constraints.gridx = 3;
            constraints.gridy = 0;
            this.add((Component)this.fSelectConfigButton, constraints);
            this.fSelectConfigButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    CommunicationSettingPanel.TCPSettingPanel panel = new CommunicationSettingPanel.TCPSettingPanel();
                    SplittedDlg dlg = SplittedDlg.create(null, panel, 3);
                    dlg.setTitle(Language.getString("ethernet.tcpSettingPanel.title", "Select IP address"));
                    dlg.show();
                    if (dlg.getControlPanel().getResult() != 1) {
                        return;
                    }
                    CommunicationSettingPanel.IPConfig config = panel.getIPConfig();
                    InputIPAddressPanel.this.fIPAddressJTextField.setIP(config.values[1]);
                    InputIPAddressPanel.this.fSubnetMaskJTextField.setIP(config.values[2]);
                    InputIPAddressPanel.this.fGatewayJTextField.setIP(config.values[3]);
                }
            });
            this.fSelectConfigButton.setVisible(selectButtonVisible);
            constraints.gridx = 4;
            constraints.gridy = 0;
            constraints.gridheight = 3;
            constraints.weightx = 1.0;
            this.add((Component)new JPanel(), constraints);
        }

        public void setIPConfig(CommunicationSettingPanel.IPConfig config) {
            if (config != null) {
                this.fIPAddressJTextField.setIP(config.values[1]);
                this.fSubnetMaskJTextField.setIP(config.values[2]);
                this.fGatewayJTextField.setIP(config.values[3]);
            }
        }

        public CommunicationSettingPanel.IPConfig getIPConfig() {
            CommunicationSettingPanel.IPConfig config = new CommunicationSettingPanel.IPConfig();
            config.values[1] = this.fIPAddressJTextField.getIP();
            config.values[2] = this.fSubnetMaskJTextField.getIP();
            config.values[3] = this.fGatewayJTextField.getIP();
            return config;
        }

        public boolean checkFieldContents() {
            if (!IPAddressJTextField.isIPAddressLegal(this.fIPAddressJTextField.getIP())) {
                new LogoError(null, "ethernet.ethernetConfigurePanel.wrongAddress", "Please enter a valid IP address.", 2, 0).display();
                return false;
            }
            if (!SubnetMaskJTextField.isSubnetLegal(this.fSubnetMaskJTextField.getIP())) {
                new LogoError(null, "panel.ip.msg.invalidSubnetMask", "The subnet mask is not valid. Check the value to make sure it was entered correctly.", 2, 0).display();
                return false;
            }
            if (!(Util.isEmptyString(this.fGatewayJTextField.getIP()) || this.fGatewayJTextField.getIP().equals("   .   .   .   ") || IPAddressJTextField.isIPAddressLegal(this.fGatewayJTextField.getIP()))) {
                new LogoError(null, "ethernet.ethernetConfigurePanel.wrongGateway", "Please enter a valid gateway.", 2, 0).display();
                return false;
            }
            return true;
        }
    }

    public static class SelectIPAddressPanel
    extends BorderJPanel {
        private static final long serialVersionUID = 1L;
        private IPAddressJTextField fIPAddress;
        private JButton fSelectButton;

        public SelectIPAddressPanel() {
            this.initComponents();
        }

        private void initComponents() {
            this.setLayout(new FlowLayout());
            this.fIPAddress = new IPAddressJTextField();
            this.fIPAddress.setIP(LogoProperties.instance().getProperty("LOGOIpAddress", "192.168.1.1"));
            this.fSelectButton = new JButton(Language.getString("tool.ipConfigurePanel.Select", "Select"));
            this.fSelectButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    CommunicationSettingPanel.TCPSettingPanel tcpSetPanel = new CommunicationSettingPanel.TCPSettingPanel();
                    tcpSetPanel.setPreferredSize(new Dimension(480, 200));
                    SplittedDlg dlg = SplittedDlg.create(null, tcpSetPanel, 3);
                    dlg.setTitle(Language.getString("ethernet.tcpSettingPanel.title", "Select IP address"));
                    dlg.show();
                    if (dlg.getControlPanel().getResult() != 1) {
                        return;
                    }
                    SelectIPAddressPanel.this.fIPAddress.setIP(LogoProperties.instance().getProperty("LOGOIpAddress", ""));
                }
            });
            this.add(this.fIPAddress);
            this.add(this.fSelectButton);
        }

        public String getIPAddress() {
            return this.fIPAddress.getIP();
        }

        public boolean checkFieldContents() {
            if (!IPAddressJTextField.isIPAddressLegal(this.fIPAddress.getIP())) {
                new LogoError(null, "extra.ipConfigure.invalidDestination", "Please enter a valid destination IP address.", 2, 0).display();
                return false;
            }
            return true;
        }
    }

    public static class SetSlaveModePanel
    extends BorderJPanel {
        private static final long serialVersionUID = 1L;
        private JRadioButton fNormalModeButton;
        private JRadioButton fSlaveModeButton;
        private IPAddressJTextField fMasterIP;
        private String slaveModeString = Language.getString("tool.ipConfigurePanel.slaveMode", "Slave mode");
        private String masterModeString = Language.getString("tool.ipConfigurePanel.masterMode", "Normal mode");

        public SetSlaveModePanel() {
            this.initComponents();
        }

        private void initComponents() {
            this.setLayout(new GridBagLayout());
            this.fNormalModeButton = new JRadioButton(this.masterModeString);
            this.fNormalModeButton.setSelected(true);
            this.fSlaveModeButton = new JRadioButton(this.slaveModeString);
            this.fSlaveModeButton.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent e) {
                    SetSlaveModePanel.this.fMasterIP.setEnabled(e.getStateChange() == 1);
                }
            });
            this.fMasterIP = new IPAddressJTextField();
            this.fMasterIP.setEnabled(false);
            GridBagConstraints constraints = new GridBagConstraints();
            constraints.fill = 0;
            constraints.anchor = 17;
            constraints.insets = new Insets(0, 2, 2, 4);
            constraints.gridx = 0;
            constraints.gridy = 0;
            constraints.gridwidth = 2;
            this.add((Component)this.fNormalModeButton, constraints);
            constraints.insets = new Insets(0, 2, 2, 4);
            constraints.gridx = 0;
            constraints.gridy = 1;
            constraints.gridwidth = 2;
            this.add((Component)this.fSlaveModeButton, constraints);
            ButtonGroup group = new ButtonGroup();
            group.add(this.fNormalModeButton);
            group.add(this.fSlaveModeButton);
            constraints.gridx = 0;
            constraints.gridy = 2;
            constraints.gridwidth = 1;
            constraints.insets = new Insets(0, 25, 4, 4);
            this.add((Component)new JLabel(Language.getString("tool.ipConfigurePanel.masterIP", "Master IP")), constraints);
            constraints.gridx = 1;
            constraints.gridy = 2;
            constraints.insets = new Insets(0, 4, 4, 4);
            this.add((Component)this.fMasterIP, constraints);
            constraints.gridx = 2;
            constraints.gridy = 2;
            constraints.weightx = 1.0;
            this.add((Component)new JPanel(), constraints);
        }

        public boolean isSlaveMode() {
            return this.fSlaveModeButton.isSelected();
        }

        public String getIPAddress() {
            return this.fMasterIP.getIP();
        }

        public boolean checkFieldContents() {
            if (this.fSlaveModeButton.isSelected() && !IPAddressJTextField.isIPAddressLegal(this.fMasterIP.getIP())) {
                new LogoError(null, "tool.ipConfigurePanel.incorrectMasterIP", "Please enter a valid master IP address.", 2, 0).display();
                return false;
            }
            return true;
        }
    }
}

